package w83b.w83bDAO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bActasIncidenciaBean;
import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bEscrutinioBean;
import w83b.w83bBeans.W83bIncidenciaHistorialActaBean;
import w83b.w83bBeans.W83bIncidenciaImpugnacionBean;
import w83b.w83bBeans.W83bIncidenciasBean;
import w83b.w83bBeans.W83bListaDiferenciasBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bBeans.W83bPapeletasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;





// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIIncidenciasDAO.
 */
public interface W83bIIncidenciasDAO {
	
	/**
	 * Buscar incidencias.
	 *
	 * @param param the param
	 * @param contar the contar
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param,boolean contar)throws Exception;
	
	/**
	 * Contar incidencias.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarIncidencias(w83b.w83bBeans.W83bIncidenciasBean param)throws Exception;
	
	/**
	 * Buscar delegados incidencias.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarDelegadosIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * No existe dni delegados.
	 *
	 * @param territorioActa the territorio acta
	 * @param anyoActa the anyo acta
	 * @param numActa the num acta
	 * @param dniDelegado the dni delegado
	 * @param usuario the usuario
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean noExisteDniDelegados(String territorioActa, String anyoActa,String numActa, String dniDelegado,W83bUsuarioXLNetsBean usuario,String fechaEntrada) throws Exception;
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidenciaNoValidadaAnterior(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidenciaNoValidadaAnteriorPorVersion(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public List existeActaIncidenciaNoValidadaAnteriorReturnNIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Existe acta incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeActaIncidenciaNoValidadaPosterior(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Existe acta tabla actas.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public List existeActaTablaActas(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Existe incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Validar fecha entrada incidencia.
	 *
	 * @param incidencia the incidencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String validarFechaEntradaIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Max version incidencia.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxVersionIncidencia(String actaTerritorio, String actaAnyo, String actaNum)throws Exception;
	
	/**
	 * Max version incidencia.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxVersionIncidenciaValidadaNoValidadaDescartada(String actaTerritorio, String actaAnyo, String actaNum)throws Exception;
	
	/**
	 * Max version incidencia.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxVersionIncidenciaNoValidado(String actaTerritorio, String actaAnyo, String actaNum)throws Exception;
	
	/**
	 * Max version incidencia.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxVersionIncidenciaValidada(String actaTerritorio, String actaAnyo, String actaNum)throws Exception;
	/**
	 * Max version incidencia.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxVersionIncidenciaValidadaNoValidada(String actaTerritorio, String actaAnyo, String actaNum)throws Exception;
	/**
	 * Max version incidencia.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxVersionIncidenciaValidadaNoValidadaNoActual(String actaTerritorio, String actaAnyo, String actaNum, String version)throws Exception;
	
	/**
	 * Encontrar diferencias acta.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param version the version
	 * @param idioma the idioma
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List encontrarDiferenciasActa(String actaTerritorio, String actaAnyo, String actaNum, String version,String idioma) throws Exception;
	
	/**
	 * Obtener docs actas.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param version the version
	 * @param idioma the idioma
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerDocsActas(String actaTerritorio, String actaAnyo, String actaNum, String version,String idioma) throws Exception;
	
	/**
	 * Obtener escrutinio.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param version the version
	 * @param idioma the idioma
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerEscrutinio(String actaTerritorio, String actaAnyo, String actaNum, String version,String idioma) throws Exception;
	
	/**
	 * Obtener papeletas.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param version the version
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerPapeletas(String actaTerritorio, String actaAnyo, String actaNum, String version) throws Exception;
	
	/**
	 * Obtener actas.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param actaVersion the acta version
	 * @param idioma the idioma
	 * @return the w83b actas incidencia bean
	 * @throws Exception the exception
	 */
	public W83bActasIncidenciaBean obtenerActas(String actaTerritorio, String actaAnyo, String actaNum,String actaVersion, String idioma) throws Exception;
	
	/**
	 * Anyadir incidencia.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirIncidencia(W83bNuevaIncidenciasBean param)throws Exception;
	
	/**
	 * Anyadir incidencia tipo sustitucion.
	 *
	 * @param param the param
	 * @param dniSustituido the dni sustituido
	 * @param dniSustituto the dni sustituto
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirIncidenciaTipoSustitucion(W83bNuevaIncidenciasBean param,String dniSustituido, String dniSustituto)throws Exception;
	
	/**
	 * Anyadir incidencia auditoria.
	 *
	 * @param param the param
	 * @param modo the modo
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirIncidenciaAuditoria(W83bNuevaIncidenciasBean param,String modo)throws Exception;
	
	/**
	 * Insertar diferencia.
	 *
	 * @param diferencia the diferencia
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarDiferencia(W83bListaDiferenciasBean diferencia) throws Exception;
	
	/**
	 * Insertar escrutinio.
	 *
	 * @param escrutinio the escrutinio
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarEscrutinio(W83bEscrutinioBean escrutinio) throws Exception;
	
	/**
	 * Insertar docs actas.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarDocsActas(w83b.w83bBeans.W83bDocBeanIncidencia param) throws Exception;
	
	/**
	 * Insertar papeletas.
	 *
	 * @param papeletas the papeletas
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarPapeletas(W83bPapeletasBean papeletas) throws Exception;
	
	/**
	 * Actualizar delegados sustituidos incidencias.
	 *
	 * @param delegado the delegado
	 * @param versionActa the version acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String actualizarDelegadosSustituidosIncidencias(W83bDelegadosBean delegado,String versionActa) throws Exception;
	
	/**
	 * Insertar delegado.
	 *
	 * @param delegado the delegado
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarDelegado(W83bDelegadosBean delegado,boolean fActuSysDate) throws Exception;
	
	/**
	 * Insertar acta.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarActa(W83bActasIncidenciaBean acta) throws Exception;
	
	/**
	 * Max docs actas.
	 *
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxDocsActas() throws Exception ;
	
	/**
	 * Obtener impugnaciones.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param version the version
	 * @param idioma the idioma
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerImpugnaciones(String actaTerritorio, String actaAnyo, String actaNum, String version, String idioma)	throws Exception;
	
	/**
	 * Buscar historial tramitacion incidencias.
	 *
	 * @param actaTerritorio the acta territorio
	 * @param actaAnyo the acta anyo
	 * @param actaNum the acta num
	 * @param version the version
	 * @param idioma the idioma
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarHistorialTramitacionIncidencias(String actaTerritorio, String actaAnyo, String actaNum, String version, String idioma) throws Exception;
	
	/**
	 * Anyadir incidencia historial tramitacion.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirIncidenciaHistorialTramitacion(W83bIncidenciaHistorialActaBean param)throws Exception;
	
	/**
	 * Anyadir impugnacion incidencia.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirImpugnacionIncidencia(W83bIncidenciaImpugnacionBean param)throws Exception;
	
	/**
	 * Buscar delegado incidencias.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarDelegadoIncidencias(w83b.w83bBeans.W83bDelegadosBean param) throws Exception;
	
	/**
	 * Insertar docs incidencias.
	 *
	 * @param param the param
	 * @throws Exception the exception
	 */
	public String insertarDocsIncidencias(W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Anyadir incidencia historial.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String anyadirIncidenciaHistorial(W83bNuevaIncidenciasBean param,String fechaRegistro)throws Exception;
	
	/**
	 * Insertar campos modif subsanaciones.
	 *
	 * @param incidencia the incidencia
	 * @param campo the campo
	 * @param valorAnterior the valor anterior
	 * @param valorActual the valor actual
	 * @return the string
	 * @throws Exception the exception
	 */
	public String insertarCamposModifSubsanaciones(W83bNuevaIncidenciasBean incidencia,String campo,String valorAnterior, String valorActual) throws Exception;
	
	/**
	 * Detalle incidencias.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List detalleIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Obtener cambios subsanacion incidencias.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List obtenerCambiosSubsanacionIncidencias(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Obtener delegados sustitucion.
	 *
	 * @param incidencia the incidencia
	 * @return the list
	 * @throws Exception the exception
	 */
	public List obtenerDelegadosSustitucion(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Buscar detalle delegado incidencias.
	 *
	 * @param param the param
	 * @param bajaVersionAnterior the baja version anterior
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarDetalleDelegadoIncidencias(w83b.w83bBeans.W83bDelegadosBean param,boolean bajaVersionAnterior) throws Exception;
	
	/**
	 * Obtener registros auditoria.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List obtenerRegistrosAuditoria(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Obtener registros tramitacion.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List obtenerRegistrosTramitacion(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Max id sustitucion.
	 *
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxIdSustitucion()throws Exception;
	
	/**
	 * Actualizar acta validada.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String actualizarActaValidada(W83bNuevaIncidenciasBean param)throws Exception;
	
	/**
	 * Actualizar incidencia.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String actualizarIncidencia(W83bNuevaIncidenciasBean param)throws Exception;
	
	/**
	 * Obtener documentos incidencia.
	 *
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List obtenerDocumentosIncidencia(w83b.w83bBeans.W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Descargar documento.
	 *
	 * @param param the param
	 * @return the w83b.w83b beans. w83b doc bean
	 * @throws Exception the exception
	 */
	public w83b.w83bBeans.W83bDocBean descargarDocumento (java.lang.String param) throws Exception;
	
	/**
	 * Borrar docs incidencias.
	 *
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarDocsIncidencias(W83bNuevaIncidenciasBean param) throws Exception;
	
	/**
	 * Borrar subsanacion.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarSubsanacion(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tabla tipo sustitucion.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTablaTipoSustitucion(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tabla historial incidencia.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTablaHistorialIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tabla auditoria incidencia.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTablaAuditoriaIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tabla doc incidencia.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTablaDocIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tabla incidencia.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTablaIncidencia(String territorioInc, String anyoInc, String numInc, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	public boolean borrarTablaIncidenciaPorActa(String territorioInc, String anyoActa, String numActa, W83bUsuarioXLNetsBean usuarioBean,boolean porActaParcial) throws Exception;
	
	/**
	 * Carga tipos documento incidencias.
	 *
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List cargaTiposDocumentoIncidencias(HashMap param) throws Exception;
	
	/**
	 * Borrar tabla delegados.
	 *
	 * @param territorioInc the territorio inc
	 * @param anyoInc the anyo inc
	 * @param numInc the num inc
	 * @param version the version
	 * @param delegado the delegado
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTablaDelegados(String territorioInc, String anyoInc, String numInc, String version, String delegado ,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Actualizar acta n delegados totales.
	 *
	 * @param acta the acta
	 * @return the string
	 * @throws Exception the exception
	 */
	public String actualizarActaNDelegadosTotales(W83bActasIncidenciaBean acta)throws Exception;
	
	/**
	 * Max incidencia.
	 *
	 * @return the string
	 * @throws Exception the exception
	 */
	public String maxIncidencia(String anyo,String territorio)throws Exception;
	
	public String validarFechaEntradaIncidenciaAnterior(W83bNuevaIncidenciasBean incidencia) throws Exception;
	public String validarFechaEntradaIncidenciaPosterior(W83bNuevaIncidenciasBean incidencia,String version) throws Exception;
	public boolean existeIncidenciaPosteriorNoValidada(W83bIncidenciasBean incidencia) throws Exception;
	
	public String buscarCierre(W83bNuevaIncidenciasBean incidencia,boolean fechaSistema) throws Exception;
	
	public String actualizarImpugnacionIncidencia(W83bIncidenciaImpugnacionBean param)throws Exception;
	
	public String actualizarDelegadosActaVersionAnterior(String territorioInc, String anyoInc, String numInc, String version, W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	public void editarHistorialTramitacion(W83bActasBean param) throws Exception;
	
	public HashMap buscarNumActaIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	public String actualizarIncidenciaSimple(W83bNuevaIncidenciasBean param)throws Exception;
	
	public String validarFechaValidacionIncidenciaAnterior(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	public String validarFechaValidacionIncidenciaAnteriorNIncidencia(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	public String versionIncidencia(String incidenciaTerritorio, String incidenciaAnyo, String incidenciaNum)throws Exception;
	
	public String maxVersionIncidenciaAnteriorValidadaNoValidadaNoActual(String actaTerritorio, String actaAnyo, String actaNum, String version)throws Exception;
	
	public boolean buscarHistorialTramitacion(W83bNuevaIncidenciasBean bean) throws Exception;
	
	public String actualizarIncidenciaHistorial(W83bNuevaIncidenciasBean param,String fechaRegistro)throws Exception;
	
	public String columnaNuevaT16(W83bNuevaIncidenciasBean incidencia) throws Exception;
	
	/**
	 * Actualiza la informacin de acuse de recibo de una lista de comunicaciones de incidencias
	 * @param listaComunicacionesAcuse List
	 * @throws Exception the exception
	 */
	public void actualizarDatosAcuseComunicacion (W83bDocBean docBean)throws Exception;
}
